/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.InterruptedError;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.OrphanedThreadException;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.YieldThreader;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugHandler;
import cc.tweaked.internal.cobalt.debug.DebugState;
import cc.tweaked.internal.cobalt.function.LuaFunction;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class LuaThread
extends LuaValue {
    public static long orphanCheckInterval = TimeUnit.SECONDS.toNanos(30L);
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_SUSPENDED = 1;
    private static final int STATUS_RUNNING = 2;
    private static final int STATUS_NORMAL = 3;
    private static final int STATUS_DEAD = 4;
    private static final String[] STATUS_NAMES = new String[]{"suspended", "suspended", "running", "normal", "dead"};
    final State state;
    private final LuaState luaState;
    private LuaTable env;
    private LuaValue errFunc;
    private final DebugState debugState;
    final LuaFunction function;

    public LuaThread(LuaState state, LuaTable env) {
        super(8);
        this.state = new State(this, 2);
        this.luaState = state;
        this.debugState = new DebugState(state);
        this.env = env;
        this.function = null;
    }

    public LuaThread(LuaState state, LuaFunction func, LuaTable env) {
        super(8);
        if (func == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        this.state = new State(this, 0);
        this.luaState = state;
        this.debugState = new DebugState(state);
        this.env = env;
        this.function = func;
    }

    @Override
    public LuaThread optThread(LuaThread defval) {
        return this;
    }

    @Override
    public LuaThread checkThread() {
        return this;
    }

    @Override
    public LuaTable getMetatable(LuaState state) {
        return state.threadMetatable;
    }

    @Override
    public LuaTable getfenv() {
        return this.env;
    }

    @Override
    public void setfenv(LuaTable env) {
        this.env = env;
    }

    public String getStatus() {
        return STATUS_NAMES[this.state.status];
    }

    public boolean isMainThread() {
        return this.luaState.getMainThread() == this;
    }

    public boolean isAlive() {
        return this.state.status != 4;
    }

    public static LuaFunction getCallstackFunction(LuaState state, int level) {
        DebugFrame info = DebugHandler.getDebugState(state).getFrame(level);
        return info == null ? null : info.func;
    }

    public DebugState getDebugState() {
        return this.debugState;
    }

    public LuaValue getErrorFunc() {
        return this.errFunc;
    }

    public LuaValue setErrorFunc(LuaValue errFunc) {
        LuaValue prev = this.errFunc;
        this.errFunc = errFunc;
        return prev;
    }

    public static Varargs yield(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        Objects.requireNonNull(args, "args cannot be null");
        LuaThread.checkYield(state);
        if (state.currentThread.state.javaCount == 0) {
            throw UnwindThrowable.yield(args);
        }
        try {
            return LuaThread.yieldBlockingImpl(state, args);
        }
        catch (InterruptedException e) {
            throw new InterruptedError(e);
        }
    }

    public static Varargs yieldBlocking(LuaState state, Varargs args) throws LuaError, InterruptedException {
        Objects.requireNonNull(args, "args cannot be null");
        LuaThread.checkYield(state);
        return LuaThread.yieldBlockingImpl(state, args);
    }

    private static void checkYield(LuaState state) throws LuaError {
        LuaThread thread = state.currentThread;
        if (thread.state.status != 2) {
            throw new LuaError("cannot yield a " + STATUS_NAMES[thread.state.status] + " thread");
        }
        if (thread.isMainThread()) {
            throw new LuaError("cannot yield main thread");
        }
    }

    private static Varargs yieldBlockingImpl(LuaState state, Varargs args) throws InterruptedException, LuaError {
        State current = state.currentThread.state;
        state.currentThread = current.previousThread;
        current.status = 1;
        current.previousThread = null;
        return LuaThread.transferControl(state, current, args);
    }

    public static Varargs resume(LuaState state, LuaThread thread, Varargs args) throws LuaError, UnwindThrowable {
        LuaThread current = state.currentThread;
        State currentState = current.state;
        if (currentState.status != 2) {
            throw new LuaError("cannot resume from a " + STATUS_NAMES[currentState.status] + " thread");
        }
        State threadState = thread.state;
        if (threadState.status > 1) {
            throw new LuaError("cannot resume " + STATUS_NAMES[threadState.status] + " coroutine");
        }
        if (currentState.javaCount == 0) {
            throw UnwindThrowable.resume(thread, args);
        }
        try {
            state.currentThread = thread;
            currentState.status = 3;
            threadState.previousThread = current;
            current = null;
            thread = null;
            return LuaThread.transferControl(state, currentState, args);
        }
        catch (InterruptedException e) {
            throw new InterruptedError(e);
        }
    }

    public static void suspend(LuaState state) throws LuaError, UnwindThrowable {
        State current = state.currentThread.state;
        if (current.status != 2) {
            throw new LuaError("cannot suspend a " + STATUS_NAMES[current.status] + " thread");
        }
        if (current.javaCount == 0) {
            throw UnwindThrowable.suspend();
        }
        LuaThread.suspendBlocking(state);
    }

    public static void suspendBlocking(LuaState state) throws LuaError {
        State current = state.currentThread.state;
        if (current.status != 2) {
            throw new LuaError("cannot suspend a " + STATUS_NAMES[current.status] + " thread");
        }
        try {
            current.status = 1;
            state.threader.running = false;
            LuaThread.transferControl(state, current, null);
        }
        catch (InterruptedException e) {
            throw new InterruptedError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Varargs transferControl(LuaState state, State thread, Varargs args) throws InterruptedException, LuaError {
        YieldThreader threader = state.threader;
        if (thread.resumeLock == null) {
            thread.resumeLock = threader.lock.newCondition();
        }
        threader.lock.lockInterruptibly();
        try {
            thread.needsThreadedResume = true;
            threader.set(args);
            threader.loop.signal();
            while (thread.resumeLock.awaitNanos(orphanCheckInterval) <= 0L) {
                if (state.abandoned) {
                    throw new InterruptedException("Abandoned state");
                }
                if (thread.owner.get() != null) continue;
                throw new OrphanedThreadException();
            }
            Varargs varargs = threader.unpack();
            return varargs;
        }
        finally {
            threader.lock.unlock();
            thread.needsThreadedResume = false;
        }
    }

    public static Varargs runMain(LuaState state, LuaFunction function) throws LuaError, InterruptedException {
        return LuaThread.run(state, state.getMainThread(), function, Constants.NONE);
    }

    public static Varargs runMain(LuaState state, LuaFunction function, Varargs args) throws LuaError, InterruptedException {
        return LuaThread.run(state, state.getMainThread(), function, args);
    }

    public static Varargs run(LuaThread thread, Varargs args) throws LuaError, InterruptedException {
        return LuaThread.run(thread.luaState, thread, null, args);
    }

    private static Varargs run(final LuaState state, LuaThread thread, final LuaFunction function, Varargs args) throws LuaError, InterruptedException {
        final YieldThreader threader = state.threader;
        threader.lock.lock();
        try {
            state.currentThread = thread;
            threader.set(args);
            threader.running = true;
            Runnable task = new Runnable(){
                LuaFunction func;
                {
                    this.func = function;
                }

                @Override
                public void run() {
                    try {
                        threader.lock.lockInterruptibly();
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        System.out.println("Interrupted");
                        return;
                    }
                    try {
                        LuaFunction function22 = this.func;
                        this.func = null;
                        Varargs res = LuaThread.loop(state, state.currentThread, function22, threader.unpack());
                        threader.set(res);
                        threader.running = false;
                        threader.loop.signal();
                    }
                    catch (TransferredControlThrowable function22) {
                    }
                    catch (Throwable e) {
                        threader.set(e);
                        threader.running = false;
                        threader.loop.signal();
                    }
                    finally {
                        threader.lock.unlock();
                    }
                }
            };
            while (threader.running && state.currentThread != null) {
                threader.execute(task);
                threader.loop.await();
            }
            Varargs varargs = threader.unpack();
            return varargs;
        }
        catch (InterruptedError e) {
            throw e.getCause();
        }
        finally {
            threader.lock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Varargs loop(LuaState state, LuaThread thread, LuaFunction function, Varargs args) throws LuaError, TransferredControlThrowable {
        threader = state.threader;
        le = null;
        do {
            block19: {
                threadState = thread.state;
                ds = thread.debugState;
                state.currentThread = thread;
                if (threadState.status == 0 && function == null) {
                    function = thread.function;
                }
                thread = null;
                try {
                    if (function != null) {
                        threadState.status = 2;
                        toExecute = function;
                        function = null;
                        try {
                            args = toExecute.invoke(state, args);
                        }
                        catch (Exception | VirtualMachineError e) {
                            args = null;
                            le = LuaError.wrap(e);
                        }
                        break block19;
                    }
                    if (threadState.needsThreadedResume) {
                        if (le != null) {
                            throw new IllegalStateException("Cannot resume a threaded coroutine with an error.");
                        }
                        threader.set(args);
                        threadState.status = 2;
                        threadState.resumeLock.signal();
                        throw TransferredControlThrowable.INSTANCE;
                    }
                    threadState.status = 2;
                    while (true) {
                        ** try [egrp 2[TRYBLOCK] [2, 3 : 141->233)] { 
lbl32:
                        // 1 sources

                        break;
lbl33:
                        // 2 sources

                        catch (Exception | VirtualMachineError e) {
                            args = null;
                            le = LuaError.wrap(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (UnwindThrowable e) {
                    if (e.isSuspend()) {
                        threadState.status = 1;
                        return null;
                    }
                    if (e.isYield()) {
                        threadState.status = 1;
                        previous = threadState.previousThread;
                        threadState.previousThread = null;
                        thread = previous;
                        args = e.getArgs();
                        continue;
                    }
                    threadState.status = 3;
                    next = e.getThread();
                    next.state.previousThread = state.currentThread;
                    thread = next;
                    args = e.getArgs();
                    continue;
                }
                block8: while (true) {
                    if (le != null) {
                        frame = LuaThread.findErrorHandler(ds);
                        if (frame == null) break;
                        err = le;
                        le = null;
                        args = frame.resumeError(state, err);
                    }
                    while ((frame = ds.getStack()) != null) {
                        if ((frame.flags & 1024) != 0 && (frame = LuaThread.findErrorHandler(ds)) == null) continue block8;
                        args = frame.resume(state, args);
                    }
                    break;
                }
            }
            threadState.status = 4;
            previous = threadState.previousThread;
            threadState.previousThread = null;
            thread = previous;
            if (le == null) continue;
            le.fillTracebackNoHandler(state);
            i = 0;
            while ((di = ds.getFrame(i)) != null) {
                di.cleanup();
                ++i;
            }
        } while (thread != null);
        if (le != null) {
            throw le;
        }
        return args;
    }

    private static DebugFrame findErrorHandler(DebugState ds) {
        int i = 0;
        DebugFrame frame;
        while ((frame = ds.getFrame(i)) != null && (frame.flags & 0x10) == 0) {
            ++i;
        }
        return frame;
    }

    private static class TransferredControlThrowable
    extends Throwable {
        private static final long serialVersionUID = 6854182520592525282L;
        static final TransferredControlThrowable INSTANCE = new TransferredControlThrowable();

        private TransferredControlThrowable() {
            super(null, null, true, false);
        }
    }

    static class State {
        final WeakReference<LuaThread> owner;
        int status;
        LuaThread previousThread;
        int javaCount = 0;
        Condition resumeLock;
        boolean needsThreadedResume;

        State(LuaThread owner, int status) {
            this.owner = new WeakReference<LuaThread>(owner);
            this.status = status;
        }
    }
}

